/*
 * Decompiled with CFR 0.152.
 */
package tiled.plugins.mappy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import tiled.plugins.mappy.Util;

public class Chunk {
    private String headerTag;
    private int chunkSize;
    private ByteArrayInputStream bais;
    private ByteArrayOutputStream out;

    public Chunk(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        inputStream.read(byArray);
        this.headerTag = new String(byArray);
        this.chunkSize = (int)Util.readLongReverse(inputStream);
        if (this.chunkSize > 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[this.chunkSize];
            int n = inputStream.read(byArray2, 0, this.chunkSize);
            if (n != this.chunkSize) {
                throw new IOException("Incomplete read!");
            }
            byteArrayOutputStream.write(byArray2);
            this.bais = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
    }

    public Chunk(String string) {
        this.headerTag = string;
        this.out = new ByteArrayOutputStream();
    }

    public boolean isGood() {
        return this.chunkSize > 0;
    }

    public boolean equals(Object object) {
        if (object instanceof String) {
            return object.equals(this.headerTag);
        }
        if (object instanceof Chunk) {
            return ((Chunk)object).headerTag.equals(this.headerTag);
        }
        return false;
    }

    public int size() {
        return this.headerTag.length() + this.out.size() + 4;
    }

    public void write(OutputStream outputStream) throws IOException {
        byte[] byArray = this.out.toByteArray();
        outputStream.write(this.headerTag.getBytes());
        Util.writeLongReverse(byArray.length - (this.headerTag.length() + 4), outputStream);
        outputStream.write(byArray);
    }

    public InputStream getInputStream() {
        return this.bais;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }
}

